<?php
class ControllerModulelivechat extends Controller {
	
	public function index() {
		
        $data = array();
        
		$data['livechat_license_number'] = $this->config->get('livechat_license_number');
		
		if($this->config->get('livechat_cart') == 'Yes') {
            $data['cart'] = $this->cart->getTotal().' '.$this->session->data['currency'];
		}
		
		if($this->config->get('livechat_mobile') == 'Yes') {
            $data['livechat_mobile'] = $this->config->get('livechat_mobile');
		}
		
		if ($this->customer->isLogged()) {
		$data['visitorName'] = $this->customer->getFirstName();
		$data['visitorName'] .= " ".$this->customer->getLastName();
		$data['visitorEmail'] = $this->customer->getEmail();
		}
				
		$data['liveChatModulePath'] = $this->url->link('module/livechat/','',$this->isSSL());
		
		if($this->config->get('livechat_status') == 'Enabled') {
            
		  return $this->load->view('module/livechat.tpl', $data);
		}
	}
	
	public function getCartValue() {
		
		$cart = array();
		$cart[0] = new stdClass();
		$cart[0]->name = "Cart value";
		$cart[0]->value = $this->cart->getTotal().' '.$this->session->data['currency'];
		
		foreach($this->cart->getProducts() as $i=>$product){
			$productURL = $this->url->link('product/product&product_id='.$product['product_id'],'',$this->isSSL());
			$quantity = ($product['quantity']>1) ? "(".$product['quantity'].")":"";
			
			$cart[$i+1] = new stdClass();
			$cart[$i+1]->name = $product['name']." ".$quantity;
			$cart[$i+1]->value = $productURL;
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($cart));
		
	}
	
	private function isSSL(){
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
		    return true;
		}
	}
}
