<?php
class ControllerModulelivechat extends Controller {
		
	private $error = array(); 

	public function index() {
		
		$this->load->language('module/livechat');
		
		$this->document->setTitle($this->language->get('heading_title_m'));
		
		$this->document->addStyle('../admin/view/template/module/css/livechat.css');
		
		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate())) {			
						
			$livechat_settings = array(
				"livechat_login"=>$this->request->post['login'],
				"livechat_license_number"=>$this->request->post['license_number'],
				"livechat_status"=>$this->request->post['livechat_status'],
				"livechat_cart"=>$this->request->post['livechat_cart'],
				"livechat_mobile"=>$this->request->post['livechat_mobile']
				);
			
			$this->model_setting_setting->editSetting('livechat', $livechat_settings);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->response->redirect($this->url->link('module/livechat', 'token=' . $this->session->data['token'], true));

		}
		
		$text_array = array('heading_title', 'heading_title_m', 'advert', 'text_edit', 'text_enabled', 'text_disabled',
                            'text_yes', 'text_no','text_on', 'text_off', 'entry_test', 'button_save', 'button_cancel', 'entry_livechat_code');
		
		foreach($text_array as $key){
			$data[$key] = $this->language->get($key);
		}
		
 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->error['livechat_code'])) {
			$data['error_livechat_code'] = $this->error['livechat_code'];
		} else {
			$data['error_livechat_code'] = '';
		}
		
		
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], true)
   		);

   		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], true)
		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title_m'),
			'href'      => $this->url->link('module/livechat', 'token=' . $this->session->data['token'], true)
   		);
				
		$data['action'] = $this->url->link('module/livechat', 'token=' . $this->session->data['token'], true);
		
		$data['cancel'] = $this->url->link('module/livechat', 'token=' . $this->session->data['token'], true);
				
		$data['session'] = $this->session->data['token'];
		
		if (isset($this->request->get['livechat_status'])) {
			$data['livechat_status'] = $this->request->get['livechat_status'];
		} else {
			$data['livechat_status'] = $this->config->get('livechat_status');
		}
		
		if (isset($this->request->get['livechat_cart'])) {
			$data['livechat_cart'] = $this->request->get['livechat_cart'];
		} else {
			$data['livechat_cart'] = $this->config->get('livechat_cart');
		}
			
		if (isset($this->request->get['license_number'])) {
			$data['livechat_license_number'] = $this->request->get['license_number'];
		} else {
			$data['livechat_license_number'] = $this->config->get('livechat_license_number');
		}
		
		if (isset($this->request->get['login'])) {
			$data['livechat_login'] = $this->request->get['login'];
		} else {
			$data['livechat_login'] = $this->config->get('livechat_login');
		}
		
		if (isset($this->request->get['livechat_mobile'])) {
			$data['livechat_mobile'] = $this->request->get['livechat_mobile'];
		} else {
			$data['livechat_mobile'] = $this->config->get('livechat_mobile');
		}
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('module/livechat.tpl', $data));
	}

	public function removeLiveChat() {
		$this->load->model('setting/setting');
		
		$this->model_setting_setting->deleteSetting('livechat');
				
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/livechat')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
			
		return !$this->error;
		
	}	
}
?>
