# LiveChat CS-Cart integration

This repository contains CS-Cart integration that let's user integrate his shop with LiveChat.

## Compatibility

We support versions: 3.0.1 - 4.7.2

Different branches contains different versions of plugin:

**Branch v3.0** is compatible with versions: 3.0.1, 3.0.2, 3.0.3, 3.0.4, 3.0.5, 3.0.6

**Branch v4.0-4.1** is compatible with versions: 4.0.1, 4.0.2, 4.0.3, 4.1.1, 4.1.2, 4.1.3, 4.1.4, 4.1.5

**Branch master** is compatible with versions: 4.2.1, 4.2.2, 4.2.3, 4.2.4, 4.3.1, 4.3.2, 4.3.3, 4.3.4, 4.3.5, 4.3.6, 4.3.7, 4.3.8, 4.3.9, 4.3.10, 4.4.1, 4.4.2, 4.4.3, 4.5.1, 4.5.2, 4.6.1, 4.6.2, 4.6.3, 4.7.1, 4.7.2

## How to make packages for distribution

To make packages, you need to checkout on version branch and zip entire catalog. Below example commands to do so.

For versions 4.2+

```
git checkout master
git pull
cd ../
zip -r livechat.zip livechat-cscart
```

For versions 3.X

```
git checkout v3.0
git pull
cd ../
zip -r livechat.zip livechat-cscart
```

For versions 4.0.X-4.1.X

```
git checkout v4.0-4.1
git pull
cd ../
zip -r livechat.zip livechat-cscart
```

Remember to delete .git files before you distribute this package (simply delete .git directory) - I didn't do it on example codes.

## How to install

### On CS-Cart 4.2+

1.  Open admin dashboard
2.  Go to Add-ons tab (you can find this on top navbar)
3.  Click "+"
4.  Upload package
5.  Find LiveChat on add-ons list.
6.  Configure add-on

If you installed this integration before there can be issues with cache. [Check how to clear a cache](https://docs.cs-cart.com/4.3.x/developer_guide/getting_started/cache_clearing.html).

### On CS-Cart 4.0.X-4.1.X

TODO

### On CS-Cart 3.X

TODO

## Test environment

It's hard to get previous versions of the CS-Cart. If you want to test a certain version of CS-Cart, reach out to their support.

## Changelog

### v. 1.1.4

- Removed disable sounds option as it is available in new [Chat Widget configurator](https://my.livechatinc.com/settings/theme/additionaltweaks). 

### v. 1.1.3

- Fixed LiveChat app image

### v. 1.1.2

- Fixed SSO button
- Fixed link to create account

### v. 1.1.1

- Fixed layout
- Fixed notifications
- Add more intervals

### v. 1.1.0

- Integration is compatible with 3.0.1 - 4.7.2 versions of CS-Cart
- User use SSO to authenticate (at this moment we use https://addons.livechatinc.com/sign-in-with-livechat)
- Integration automatically injects LiveChat snippet into shop template
- User can hide LiveChat widget on mobile
- User can disable sounds
- Integration tracks shopping cart (product title, quantity, product URL, cart value)

## Author of the integration

Integration belongs to LiveChat Inc.  
Author of the integration: [Ruslan Belziuk](https://www.upwork.com/freelancers/~016ef2e17810868b56) from http://dumka.pro/  
Project supervisor: Przemys;aw Bitkowski, [p.bitkowski@livechatinc.com](p.bitkowski@livechatinc.com), slack: @p.bitkowski  
Distribution: Daniel Zielinski, [d.zielinski@livechatinc.com](d.zielinski@livechatinc.com), slack: @daniel
