{* Above all controls from addon.xml *}

{$livechat_webapp_url = "https://my.livechatinc.com/signup?utm_source=cs-cart.com&utm_medium=integration&utm_campaign=cscart_integration"}
{$livechat_apps_url = "https://www.livechatinc.com/applications/?utm_source=cs-cart.com&utm_medium=integration&utm_campaign=cscart_integration"}

</td>
    <td>
        <div class="livechat-integration-app-container">
            <img src="{$images_dir}/addons/livechat/livechat-app.png" class="livechat-integration-app-img" />
            <p><a href="{$livechat_webapp_url}" target="_blank">{__("livechat.use_web_app")}</a> {__("or")} {__("livechat.check_our_apps", ["[url]" => $livechat_apps_url])|lcfirst}.</a></p>
        </div>    
    </td>
    </tr>
    </table>

    <div id="container_{$html_id}" class="control-group livechat-control-group{if $class} {$class}{/if} {$item.section_name} {if ($parent_item && $parent_item.value != "Y")}hidden{/if}">
    <div id="reset-settings-footer" class="controls">
        {if $addons.livechat.livechat_license}
            <div class="muted">
                {__("livechat.change_account")}
                <a id="livechat_delete_settings">{__("livechat.reset_settings")}</a>
            </div>
        {/if}
    </div>
</div>
</div>



{literal}
<script type="text/javascript">
//<![CDATA[
(function(_, $) {
    var saveLivechatSettings = function(license, email) {
        $('iframe#login-with-livechat').addClass('hidden');
        $('#create-account-text').addClass('hidden-with-space');
        $('.custom-livechat-login-button').removeClass('hidden');


        var $license_field = $('#addon_option_livechat_livechat_license'),
            $login_field = $('#addon_option_livechat_livechat_login');

        if ($license_field.prop('disabled') === true) {
            $license_field.siblings('.update-for-all').find('.cm-update-for-all-icon').trigger('click');
        }
        if ($login_field.prop('disabled') === true) {
            $login_field.siblings('.update-for-all').find('.cm-update-for-all-icon').trigger('click');
        }

        $license_field.val(license);
        $login_field.val(email);

        $.submitForm( $('<a data-ca-dispatch="dispatch[addons.update]" data-ca-target-form="update_addon_livechat_form" class="cm-submit"></a>') );
    };

    var processLivechatMessage = function(event) {
        if(event.origin === 'https://addons.livechatinc.com'){
            var livechatMessage = JSON.parse(event.data);
            if (livechatMessage && (livechatMessage.type === 'logged-in' && livechatMessage.eventTrigger === 'click') || livechatMessage.type === 'signed-out') {
                saveLivechatSettings(livechatMessage.license, livechatMessage.email);
            }
        }
    };

    var sendLivechatMessage = function(msg) {
        $('iframe#login-with-livechat').get(0).contentWindow.postMessage(msg, '*');
    };

    $(document).ready(function(){
        window.addEventListener('message', processLivechatMessage, false);
    });

    $(_.doc).on('click', '#livechat_delete_settings', function(e) {
        sendLivechatMessage('logout');
        e.preventDefault();
    });
}(Tygh, Tygh.$));
//]]>
</script>
{/literal}